<?php
// Inicia a sessão
session_start();
require '../conexao.php'; // Sua conexão PDO

// Verifica se 'local' está definida na sessão
if (!isset($_SESSION['local'])) {
    echo "Local não definido.<br>";
    exit;
}

$localAtual = $_SESSION['local'];

// Consulta os personagens no mesmo local
try {
    $sql = "SELECT personagem, jogador, situacao, soldados, cla, cargo, paralisado, reputacao 
            FROM personagens 
            WHERE local = :local 
            AND ativo = 1 
            AND situacao NOT IN ('escondido', 'fugindo', 'reagrupando soldados')
            ORDER BY personagem";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':local', $localAtual, PDO::PARAM_STR);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo "<h3>Personagens no local: " . htmlspecialchars($localAtual) . "</h3>";
        echo "<table border='1' style='width:100%; border-collapse: collapse;'>";
        echo "<tr style='background-color: #f2f2f2;'>
                <th>Personagem</th>
                <th>Jogador</th>
                <th>Situação</th>
                <th>Reputação</th>
                <th>Clã</th>
                <th>Cargo</th>
              </tr>";
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $situacao = htmlspecialchars($row['situacao']);
            
            // Verifica atividades com tempo (caçando/pegando madeira)
            if (in_array($row['situacao'], ['caçando', 'pegando madeira'])) {
                $paralisado = new DateTime($row['paralisado']);
                $agora = new DateTime();
                
                if ($paralisado <= $agora) {
                    $situacao .= " <span style='color: green;'>(já acabou)</span>";
                } else {
                    $situacao .= " <span style='color: #800000;'>(não acabou)</span>";
                }
            }
            
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['personagem']) . "</td>";
            echo "<td>" . htmlspecialchars($row['jogador']) . "</td>";
            echo "<td>" . $situacao . "</td>";
            echo "<td>" . htmlspecialchars($row['reputacao']) . "</td>";
            echo "<td>" . htmlspecialchars($row['cla']) . "</td>";
            echo "<td>" . htmlspecialchars($row['cargo']) . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "Nenhum personagem ativo encontrado neste local.<br>";
    }
} catch (PDOException $e) {
    die("Erro ao consultar o banco de dados: " . $e->getMessage());
}

// Verifica se a sessão 'personagem' está definida
if (isset($_SESSION['personagem'])) {
    echo "<br><strong>Seu personagem:</strong> " . htmlspecialchars($_SESSION['personagem']);
}
?>